// const express = require("express");
// const cors = require("cors");
// const bodyParser = require("body-parser");
// const mysql = require("mysql2/promise");
// const path = require("path");
// const multer = require("multer");
// const nodemailer = require("nodemailer");

// const app = express();

// app.use(bodyParser.json());
// app.use(bodyParser.urlencoded({ extended: false }));
// app.use(cors());
// app.use(express.json());

// // Serve static files from the 'images' directory
// app.use("/images", express.static(path.join(__dirname, "images")));

// const pool = mysql.createPool({
//   host: "localhost",
//   user: "root",
//   password: "",
//   database: "ventasbookshop",
//   waitForConnections: true,
//   connectionLimit: 10,
//   queueLimit: 0,
// });

// // Update the storage configuration for multer
// const storage = multer.diskStorage({
//   destination: (req, file, cb) => {
//     // All images will be stored in the 'images' folder
//     cb(null, path.join(__dirname, "images"));
//   },
//   filename: (req, file, cb) => {
//     cb(null, Date.now() + "-" + file.originalname);
//   },
// });

// const upload = multer({ storage: storage });

// // API endpoint to get all books
// app.get("/api/books", async (req, res) => {
//   try {
//     const [rows] = await pool.query("SELECT * FROM products");
//     res.json(rows);
//   } catch (error) {
//     res.status(500).json({ message: "Error retrieving books", error: error.message });
//   }
// });

// // API endpoint to add a new book
// app.post("/api/books", upload.single("image"), async (req, res) => {
//   const { name, category, unitprice, quantity } = req.body;
//   const imageUrl = req.file ? `/images/${req.file.filename}` : null;

//   try {
//     const [result] = await pool.query(
//       "INSERT INTO products (name, category, unitprice, quantity, image_url) VALUES (?, ?, ?, ?, ?)",
//       [name, category, unitprice, quantity, imageUrl]
//     );
//     res.status(201).json({ message: "Book added successfully", id: result.insertId });
//   } catch (error) {
//     res.status(500).json({ message: "Error adding book", error: error.message });
//   }
// });

// // API endpoint to send email
// app.post("/api/send-email", async (req, res) => {
//   const { name, email, phone, interest, message } = req.body;

//   // Construct email text
//   const emailText = `
//     Name: ${name}
//     Email: ${email}
//     Phone: ${phone}
//     Interest: ${interest}

//     Message:
//     ${message}
//   `;

//   const transporter = nodemailer.createTransport({
//     service: "gmail",
//     auth: {
//       user: "your-email@gmail.com",
//       pass: "your-email-password",
//     },
//   });

//   const mailOptions = {
//     from: email,
//     to: "kelvinnyagah045@gmail.com",
//     cc: "kelvinnyagah045@gmail.com",
//     subject: `New Inquiry: ${interest}`,
//     text: emailText,
//   };

//   try {
//     const info = await transporter.sendMail(mailOptions);
//     console.log("Message sent: %s", info.messageId);
//     res.status(200).json({
//       message: "Email sent successfully",
//       messageId: info.messageId,
//     });
//   } catch (error) {
//     console.error("Error sending email:", error);
//     res.status(500).json({ message: "Failed to send email", error: error.message });
//   }
// });

// app.listen(3000, () => console.log("Server running on port 3000"));


const express = require("express");
const cors = require("cors");
const bodyParser = require("body-parser");
const mysql = require("mysql2/promise");
const path = require("path");
const multer = require("multer");
const nodemailer = require("nodemailer");

const app = express();

app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));
app.use(cors());
app.use(express.json());

// Serve static files from the 'images' directory
app.use("/images", express.static(path.join(__dirname, "images")));

const pool = mysql.createPool({
  host: "localhost",
  user: "root",
  password: "",
  database: "ventascloset",
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0,
});

// Update the storage configuration for multer
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    // All images will be stored in the 'images' folder
    cb(null, path.join(__dirname, "images"));
  },
  filename: (req, file, cb) => {
    cb(null, Date.now() + "-" + file.originalname);
  },
});

const upload = multer({ storage: storage });

// API endpoint to get all clothes
app.get("/api/clothes", async (req, res) => {
  try {
    const [rows] = await pool.query("SELECT * FROM closet");
    res.json(rows);
  } catch (error) {
    res.status(500).json({ message: "Error retrieving clothes", error: error.message });
  }
});

// API endpoint to get unique categories
app.get("/api/categories", async (req, res) => {
  try {
    const [rows] = await pool.query("SELECT DISTINCT category FROM closet");
    res.json(rows.map(row => row.category));
  } catch (error) {
    res.status(500).json({ message: "Error retrieving categories", error: error.message });
  }
});

// API endpoint to add a new book
app.post("/api/clothes", upload.single("image"), async (req, res) => {
  const { name, category, quantity, amount, price } = req.body;
  const imageUrl = req.file ? `/images/${req.file.filename}` : null;

  try {
    const [result] = await pool.query(
      "INSERT INTO closet (name, category, quantity, amount, price, image_url) VALUES (?, ?, ?, ?, ?, ?)",
      [name, category, quantity, amount, price, imageUrl]
    );
    res.status(201).json({ message: "Clothe added successfully", id: result.insertId });
  } catch (error) {
    res.status(500).json({ message: "Error adding clothe", error: error.message });
  }
});

// API endpoint to send email
app.post("/api/send-email", async (req, res) => {
  const { name, email, phone, interest, message } = req.body;

  // Construct email text
  const emailText = `
    Name: ${name}
    Email: ${email}
    Phone: ${phone}
    Interest: ${interest}

    Message:
    ${message}
  `;

  const transporter = nodemailer.createTransport({
    service: "gmail",
    auth: {
      user: "your-email@gmail.com",
      pass: "your-email-password",
    },
  });

  const mailOptions = {
    from: email,
    to: "kelvinnyagah045@gmail.com",
    cc: "kelvinnyagah045@gmail.com",
    subject: `New Inquiry: ${interest}`,
    text: emailText,
  };

  try {
    const info = await transporter.sendMail(mailOptions);
    console.log("Message sent: %s", info.messageId);
    res.status(200).json({
      message: "Email sent successfully",
      messageId: info.messageId,
    });
  } catch (error) {
    console.error("Error sending email:", error);
    res.status(500).json({ message: "Failed to send email", error: error.message });
  }
});

app.listen(3000, () => console.log("Server running on port 3000"));
